/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.lgoExImport;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.lgoExImport.CBlock;
import DE.siemens.ad.logo.util.CodeBlock;
import java.util.Vector;

public class ConvertWiringDiagram {
    WiringDiagram fSourceWD = null;
    Vector fCWDVector = null;
    Vector fSourceBlockVector = null;

    public ConvertWiringDiagram(WiringDiagram wd) {
        this.fSourceWD = wd;
        this.fSourceBlockVector = this.fSourceWD.getBlocks();
        this.createCWDVector2();
    }

    public ConvertWiringDiagram(Vector blocks) {
        this.fSourceBlockVector = blocks;
        this.createCWDVector();
    }

    private void createCWDVector() {
        if (this.fCWDVector == null) {
            Vector<CBlock> targetVector = new Vector<CBlock>(this.fSourceBlockVector.size());
            String[] targetBlocks = this.getCBlocksAsString(this.fSourceBlockVector);
            String[] sourceBlocks = this.getBlocksAsString(this.fSourceBlockVector);
            CodeBlock blockGenerator = null;
            for (int i = 0; i < targetBlocks.length; ++i) {
                try {
                    String className = ("" + this.fSourceBlockVector.get(i).getClass()).substring(6);
                    String zielKlasse = targetBlocks[i];
                    blockGenerator = new CodeBlock(zielKlasse);
                    Block uebergabe = (Block)this.fSourceBlockVector.get(i);
                    blockGenerator.addParameter(uebergabe);
                    blockGenerator.clearParameters();
                    CBlock ergebnis = (CBlock)blockGenerator.execConstructor();
                    targetVector.addElement(ergebnis);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    System.out.println("" + blockGenerator.getInternalException());
                    targetVector.addElement(new CBlock());
                }
            }
            this.fCWDVector = targetVector;
        }
    }

    private void createCWDVector2() {
        if (this.fCWDVector == null) {
            Vector<CBlock> targetVector = new Vector<CBlock>(this.fSourceBlockVector.size());
            String[] targetBlocks = this.getCBlocksAsString(this.fSourceBlockVector);
            String[] sourceBlocks = this.getBlocksAsString(this.fSourceBlockVector);
            for (int i = 0; i < targetBlocks.length; ++i) {
                try {
                    String className = ("" + this.fSourceBlockVector.get(i).getClass()).substring(6);
                    String zielKlasse = targetBlocks[i];
                    CodeBlock blockGenerator = new CodeBlock(zielKlasse);
                    Block uebergabe = (Block)this.fSourceBlockVector.get(i);
                    blockGenerator.addParameter(uebergabe);
                    CBlock ergebnis = (CBlock)blockGenerator.execConstructor();
                    targetVector.addElement(ergebnis);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    targetVector.addElement(new CBlock());
                }
            }
            this.fCWDVector = targetVector;
        }
    }

    public CBlock[] getAllCBlocks() {
        Vector cWDVector = this.fCWDVector;
        CBlock[] blocks = new CBlock[cWDVector.size()];
        for (int i = 0; i < cWDVector.size(); ++i) {
            blocks[i] = (CBlock)cWDVector.get(i);
        }
        return blocks;
    }

    private String[] getBlocksAsString(Vector source) {
        String[] targetBlocks = new String[source.size()];
        for (int i = 0; i < targetBlocks.length; ++i) {
            String className = "" + source.get(i).getClass();
            int startIndex = 6;
            targetBlocks[i] = className.substring(startIndex);
        }
        return targetBlocks;
    }

    private String[] getCBlocksAsString(Vector source) {
        String[] targetBlocks = new String[source.size()];
        for (int i = 0; i < targetBlocks.length; ++i) {
            String aktuellerString = "" + source.get(i).getClass();
            int lastPoint = aktuellerString.lastIndexOf(46);
            String path = "DE.siemens.ad.logo.model.lgoExImport.";
            String nameOfClass = aktuellerString.substring(lastPoint + 1);
            targetBlocks[i] = path + "C" + nameOfClass;
        }
        return targetBlocks;
    }

    public CBlock[] getCBlocksForString(String kennung) {
        int anzahlBlocks = 0;
        CBlock aktuellerBlock = null;
        Vector cWDVector = this.fCWDVector;
        int[] posBlocks = new int[cWDVector.size()];
        for (int i = 0; i < cWDVector.size(); ++i) {
            aktuellerBlock = (CBlock)cWDVector.get(i);
            if (!aktuellerBlock.getBlockType(kennung)) continue;
            posBlocks[anzahlBlocks] = i;
            ++anzahlBlocks;
        }
        CBlock[] blocks = new CBlock[anzahlBlocks];
        for (int i = 0; i < anzahlBlocks; ++i) {
            blocks[i] = (CBlock)cWDVector.get(posBlocks[i]);
        }
        return blocks;
    }

    public int getLastBlockNumber() {
        int biggest = 0;
        CBlock[] blocks = this.getCBlocksForString("Programm");
        for (int i = 0; i < blocks.length; ++i) {
            if (blocks[i].getBlockNumber() <= biggest) continue;
            biggest = blocks[i].getBlockNumber();
        }
        return biggest;
    }

    private int[] initialezeArray(int[] array, int wert) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = wert;
        }
        return array;
    }

    public String toString() {
        Vector cWDVector = this.fCWDVector;
        String back2 = "";
        if (this.fCWDVector.size() != 0) {
            for (int i = 0; i < cWDVector.size(); ++i) {
                String zwischen = ((CBlock)cWDVector.get(i)).toString();
                back2 = back2 + "C" + zwischen + "\n";
            }
        } else {
            back2 = null;
        }
        return back2;
    }
}

